# Contribution guide



This document will help you understand how to contribute to the project, whether you're reporting bugs, suggesting new features, or submitting code changes. We're excited to have you on board and look forward to working with you!

## Getting Started

In this section, you'll find information on how to set up your local development environment and any dependencies you need to be aware of. This will help you get started with contributing to FreeMoCap.

## Code Contributions

Contributing code to FreeMoCap involves creating and submitting pull requests. In this section, you'll learn about our development process, coding styles, and testing requirements.

#### We Use GitHub Flow

We use [Github Flow](https://docs.github.com/en/get-started/quickstart/github-flow) as our development process. It makes it easy for contributors to submit changes and maintainers to review and merge them.

  
#### We Develop with Github  
We use GitHub to host code, to track issues and feature requests, as well as accept pull requests.  
  
### We Use the [Github Flow](https://docs.github.com/en/get-started/quickstart/github-flow) Strategy, So All Code Changes Happen Through Pull Requests  
Pull requests are the best way to propose changes to the codebase (we use [Github Flow](https://docs.github.com/en/get-started/quickstart/github-flow)). We actively welcome your pull requests:  
  
1. Fork the repo and create your branch from `main`.  
2. If you've added code that should be tested, add tests.  
3. If you've changed APIs, update the documentation.  
4. Ensure the test suite passes.  
5. Make sure your code lints.  
6. Issue that pull request!

### Coding Styles

Consistent coding styles are important for maintaining a clean and easy-to-understand codebase. We use the following style guides for our project:


- [[Python Code Style Guide]]
- PyQT: [COMING SOON]
- API: [COMING SOON]


### Testing

We require tests for all code contributions to ensure the stability and reliability of the project. When submitting a pull request, make sure your code is covered by tests, and that those tests pass our Github Actions workflow.

`TODO - Include examples or more specific details as needed.`

## Reporting Bugs 

Your feedback is invaluable in improving FreeMoCap. In this section, you'll learn how to report bugs and suggest new features for the project.

For details, see our [[Bug Report]] guide

## Suggesting Features

We welcome your ideas for new features or improvements to FreeMoCap. To suggest a feature, [open a new issue](https://github.com/freemocap/freemocap/issues/new) and describe the feature, its benefits, and any potential challenges in implementing it.

For details, see our [[Feature Request]]  guide

## Pull Requests

Pull requests are the best way to propose changes to the codebase (we use [Github Flow](https://docs.github.com/en/get-started/quickstart/github-flow)). We actively welcome your pull requests:

1. Fork the repo and create your branch from `main`.
2. If you've added code that should be tested, add tests.
3. If you've changed APIs, update the documentation.
4. Ensure the test suite passes.
5. Make sure your code lints.
6. Issue that pull request!

## Getting Help  and Asking Questions

If you encounter issues or have questions while contributing to Freemocap, don't hesitate to reach out. You can ask for help on our Discord server or by creating a new issue on Github. We'll do our best to assist you and provide the information you need.

